import { useState } from 'react';
import DataTable from 'components/tables/dataTable';
// material-ui
import {
  Avatar,
  AvatarGroup,
  Box,
  Button,
  Grid,
  List,
  ListItemAvatar,
  ListItemButton,
  ListItemSecondaryAction,
  ListItemText,
  MenuItem,
  Stack,
  TextField,
  Typography,
  Tooltip,
  FormControl,
  InputAdornment,
  OutlinedInput
} from '@mui/material';

// assets
import { SearchOutlined } from '@ant-design/icons';

import { PlusIcon } from 'utils/icons';

import MainCard from 'components/MainCard';
const Customer = () => {
  const [value, setValue] = useState('today');
  const [slot, setSlot] = useState('week');

  return (
    <>
      <Grid container justifyContent="space-between" alignItems="center">
        <Grid item>
          <Typography variant="h5">Customer Managment</Typography>
        </Grid>
        <Grid item>
          <Box sx={{ width: '100%', ml: { xs: 0, md: 1 } }}>
            <FormControl sx={{ width: { xs: '100%', md: 224 } }}>
              <OutlinedInput
                size="small"
                id="header-search"
                startAdornment={
                  <InputAdornment position="start" sx={{ mr: -0.5 }}>
                    <SearchOutlined />
                  </InputAdornment>
                }
                aria-describedby="header-search-text"
                inputProps={{
                  'aria-label': 'weight'
                }}
                placeholder="Ctrl + K"
              />
            </FormControl>
          </Box>
        </Grid>
        <Grid item>
          <Tooltip title="Add Customer" placement="top">
            <Button variant="contained" color="primary" startIcon={<PlusIcon />}>
              Add
            </Button>
          </Tooltip>
        </Grid>
      </Grid>
      <MainCard sx={{ mt: 2 }} content={false}>
        <div style={{ marginLeft: '10px' }}>
          <DataTable />
        </div>
      </MainCard>
    </>
  );
};

export default Customer;
